<!DOCTYPE html>
<html lang="en">

<head>
    <link rel="shortcut icon" href="" type="image/x-icon">
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">

    <?php echo $__env->yieldContent('title'); ?>

    <link rel="stylesheet" href="<?php echo e(asset('backend/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/fontawesome/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/style.css')); ?>?v=<?php echo e($setting?->version); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/bootstrap-social.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/components.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('global/toastr/toastr.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/bootstrap4-toggle.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/dev.css')); ?>?v=<?php echo e($setting?->version); ?>">
    <?php if(session()->has('text_direction') && session()->get('text_direction') !== 'ltr'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('backend/css/rtl.css')); ?>?v=<?php echo e($setting?->version); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('backend/css/dev_rtl.css')); ?>?v=<?php echo e($setting?->version); ?>">
    <?php endif; ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/tagify.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/bootstrap-tagsinput.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/fontawesome-iconpicker.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/bootstrap-datepicker.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/clockpicker/dist/bootstrap-clockpicker.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/datetimepicker/jquery.datetimepicker.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/iziToast.min.css')); ?>">
</head>

<body>
    <div id="app">
        <?php echo $__env->yieldContent('content'); ?>
    </div>

    
    <script src="<?php echo e(asset('global/js/jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/jquery.nicescroll.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/stisla.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/scripts.js')); ?>"></script>
    <script src="<?php echo e(asset('global/toastr/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/modules-toastr.js')); ?>"></script>

    <script>
        <?php if(Session::has('messege')): ?>
            var type = "<?php echo e(Session::get('alert-type', 'info')); ?>"
            switch (type) {
                case 'info':
                    toastr.info("<?php echo e(Session::get('messege')); ?>");
                    break;
                case 'success':
                    toastr.success("<?php echo e(Session::get('messege')); ?>");
                    break;
                case 'warning':
                    toastr.warning("<?php echo e(Session::get('messege')); ?>");
                    break;
                case 'error':
                    toastr.error("<?php echo e(Session::get('messege')); ?>");
                    break;
            }
        <?php endif; ?>
    </script>
    <!-- Google reCAPTCHA -->
    <?php if(Cache::get('setting')->recaptcha_status === 'active'): ?>
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <?php endif; ?>

    <?php if($errors->any()): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <script>
                toastr.error('<?php echo e($error); ?>');
            </script>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

</body>

</html>
<?php /**PATH /home/mmfollows/skillgrow.kenyapanel.com/resources/views/admin/auth/app.blade.php ENDPATH**/ ?>