<section class="instructor__area">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-xl-4">
                <div class="instructor__content-wrap">
                    <div class="section__title mb-15">
                        <span class="sub-title"><?php echo e(__('Skilled Introduce')); ?></span>
                        <h2 class="title"><?php echo clean(processText($featuredInstructorSection?->translation?->title)); ?></h2>
                    </div>
                    <p><?php echo clean(processText($featuredInstructorSection?->translation?->sub_title)); ?></p>
                    <div class="tg-button-wrap">
                        <a href="<?php echo e($featuredInstructorSection->button_url); ?>"
                            class="btn arrow-btn"><?php echo e($featuredInstructorSection?->translation?->button_text); ?> <img
                                src="<?php echo e(asset('frontend/img/icons/right_arrow.svg')); ?>" alt="img"
                                class="injectable"></a>
                    </div>
                </div>
            </div>
            <div class="col-xl-8">
                <div class="instructor__item-wrap">
                    <div class="row">
                        <?php $__currentLoopData = $selectedInstructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($index < 4): ?>
                                <div class="col-sm-6">
                                    <div class="instructor__item">
                                        <div class="instructor__thumb">
                                            <a href="<?php echo e(route('instructor-details', $instructor->id)); ?>"><img
                                                    src="<?php echo e(asset($instructor->image)); ?>" alt="img"></a>
                                        </div>
                                        <div class="instructor__content">
                                            <h2 class="title"><a
                                                    href="<?php echo e(route('instructor-details', $instructor->id)); ?>"><?php echo e($instructor->name); ?></a>
                                            </h2>
                                            <span class="designation"><?php echo e($instructor->job_title); ?></span>
                                            <p class="avg-rating">
                                                <i class="fas fa-star"></i>
                                                <?php echo e(number_format($instructor->courses->avg('avg_rating'), 1)); ?> <?php echo e(__('Ratings')); ?>

                                            </p>
                                            <div class="instructor__social">
                                                <ul class="list-wrap">
                                                    <?php if($instructor->facebook): ?>
                                                        <li><a href="<?php echo e($instructor->facebook); ?>" aria-label="Facebook"><i class="fab fa-facebook-f"></i></a></li>
                                                    <?php endif; ?>
                                                    <?php if($instructor->twitter): ?>
                                                        <li><a href="<?php echo e($instructor->twitter); ?>" aria-label="Twitter"><i class="fab fa-twitter"></i></a></li>
                                                    <?php endif; ?>
                                                    <?php if($instructor->linkedin): ?>
                                                        <li><a href="<?php echo e($instructor->linkedin); ?>" aria-label="Linkedin"><i class="fab fa-linkedin"></i></a></li>
                                                    <?php endif; ?>
                                                    <?php if($instructor->github): ?>
                                                        <li><a href="<?php echo e($instructor->github); ?>" aria-label="Github"><i class="fab fa-github"></i></a></li>
                                                    <?php endif; ?>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/mmfollows/skillgrow.kenyapanel.com/resources/views/frontend/home/main/sections/instructor-area.blade.php ENDPATH**/ ?>